#include <algorithm>
#include <iostream>
#include <vector>
#include <utility>

#define CR const&

using namespace std;

vector<int> Prekidi(vector<int> CR niz) {
    vector<int> rezultat;
    for (int i = 1; i < niz.size(); ++i) {
        if (niz[i - 1] > niz[i]) {
            rezultat.push_back(i);
        }
    }
    return rezultat;
}
vector<bool> Otklonjivi(vector<int> CR niz, vector<int> CR prekidi) {
    vector<bool> rezultat(niz.size(), false);
    for (auto& p : prekidi) {
        rezultat[p] = niz[p - 1] <= niz[p + 1];
    }
    return rezultat;
}

int Pretreaga(vector<int> CR niz, int v) {
    int l = 0;
    int r = niz.size() - 1;
    while (l <= r) {
        int m = (l + r) / 2;
        if (niz[m] == v) {
            return m;
        }
        if (niz[m] < v) {
            l = m + 1;
            continue;
        }
        r = m - 1;
    }
    return l;
}

bool DobarPoklon(vector<int> CR niz, vector<int> CR prekidi, vector<bool> CR otklonjiv, int l, int r) {
    if (l == r) {
        return true;
    }
    int levi = Pretreaga(prekidi, l + 1);
    int desni = Pretreaga(prekidi, r + 1);
    if (levi == desni) {
        return true;
    }
    if (desni - levi == 1 && prekidi[levi] == l + 1) {
        return true;
    }
    if (desni - levi == 1) {
        return otklonjiv[prekidi[levi]];
    }
    return false;
}

void OptimiseIO() {
    ios_base::sync_with_stdio(false);
    cout.tie(0);
    cerr.tie(0);
    cin.tie(0);
}


int main() {
    OptimiseIO();
    int n;
    cin >> n;
    vector<int> poklonGenerator(n);
    for (auto& i : poklonGenerator) {
        cin >> i;
    }
    vector<int> prekidi = Prekidi(poklonGenerator);
    vector<bool> otklonjiv = Otklonjivi(poklonGenerator, prekidi);
    int q;
    cin >> q;
    vector<pair<int, int>> upiti(q);
    for (auto& p : upiti) {
        cin >> p.first >> p.second;
        --p.first;
        --p.second;
    }
    for (auto& p : upiti) {
        cout << (DobarPoklon(poklonGenerator, prekidi, otklonjiv, p.first, p.second) ? "DA" : "NE") << endl;
    }
    return 0;
}